#include <iostream>
#include <mysql++.h>

int main (int argc, char* argv[])
{
    using namespace mysqlpp;

    // Проверить, что программу запустили с параметром
    if (argc != 2) {
		std::cerr << "USAGE: " << argv[0] << " <username>" << std::endl;
        return -1;
    }

	// Обрабатывать все ошибки в конце
    try {

		// Подключиться к MySQL 
        Connection conn("mysql", "localhost", "root", "");

		// Составить запрос так, чтобы не допустить SQL injection
        Query query = conn.query();
		query << "SELECT * FROM mysql.user WHERE user = " << quote << argv[1];

		// Выполнить запрос
        StoreQueryResult res = query.store();

		// Вывести результат
        for (size_t row = 0; row < res.num_rows(); ++row) {
			for (size_t col = 0; col < res.num_fields(); ++col)
				std::cout << res[row][col] << "\t";
            std::cout << std::endl;
        }

    } catch (const std::exception& x) {
        std::cerr << "Got error: " << x.what() << std::endl;
    }
}
