/* 
   Copyright (C) 2010 Даниил Каменский <dkamenskiy@yandex.ru>
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>

MYSQL   mysql;

/* Функция выводит ошибку MySQL */
void print_error(const char* str)
{
    fprintf(stderr, "ERROR: %s\n", str ? str: mysql_error(&mysql));
}

/* Основная функция */
int main (int argc, char** argv)
{
    MYSQL_RES   *mysqlres;
    MYSQL_ROW   row;
    char        *query;
    char        *tablename;
    unsigned    rows;
    unsigned    i;

    /* Проверить, что программу запустили с параметром */
    if (argc != 2) {
        fprintf (stderr, "USAGE: %s username\n", argv[0]);
        return -1;
    }

    /* Инициализировать библиотеку mysql */
    if (!mysql_init(&mysql)) {
        print_error("Could not initialize MySQL library");
        return -1;
    }

    /* Подключиться к MySQL с параметрами пользователя по умолчанию */
    if (!mysql_real_connect(&mysql, "localhost", "root", "", "mysql", 0, NULL, 0)) {
        print_error(NULL);
        return -1;
    }

    /* Обработать параметр, чтобы не допустить SQL injection */
    tablename = malloc(strlen(argv[1]) * 2 + 1);
    mysql_real_escape_string(&mysql, tablename, argv[1], strlen(argv[1]));

    /* Составить запрос */
    query = strdup ("SELECT * FROM mysql.user WHERE user = '");
    query = realloc(query, strlen(query) + strlen(tablename) + 2);
    strcat(query, tablename);
    strcat(query, "'");

    /* Выполнить составленный запрос */
    if (mysql_query(&mysql, query)) {
        /* Освободить выделенную под составление запроса память */
        free(query);
        free(tablename);
        print_error(NULL);
        mysql_close(&mysql);
        return -1;
    }

    /* Освободить выделенную под составление запроса память */
    free(query);
    free(tablename);

    /* Прочитать результат запроса */
    if (!(mysqlres = mysql_store_result(&mysql))) {
        print_error(NULL);
        mysql_close(&mysql);
        return -1;
    }

    /* Вывести результат запроса на экран */
    rows = mysql_num_fields(mysqlres);
    while ((row = mysql_fetch_row(mysqlres))) {
        for (i = 0; i < rows; ++i)
            printf("%s\t", row[i]);
        printf("\n");
    }

    /* Освободить результат запроса */
    mysql_free_result(mysqlres);

    /* Отключиться от MySQL */
    mysql_close(&mysql);
    return 0;
}
