#! /usr/bin/env python
# encoding: utf8

import sys
import MySQLdb

# Проверить, что запущены с параметром
if len(sys.argv) != 2:
    print("USAGE: " + sys.argv[0] + " <username>")
    sys.exit(-1)

# Обрабатывать ошибки в конце
try:
    # Подключиться к базе данных
    conn = MySQLdb.connect("localhost", "root", "", "mysql")

    # Выполнить запрос
    cursor = conn.cursor()
    cursor.execute("SELECT * FROM user WHERE user = %s", (sys.argv[1]))
    rows = cursor.fetchall()

    # Вывести результат
    for row in rows:
        print("\t".join([str(col) for col in row]))

except MySQLdb.Error, e:
    print("Got error: %s" % (e.args[1]))
    sys.exit(-1)
