import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

// javac Dumper.java && CLASSPATH=/usr/share/java/mysql-connector-java-5.1.6.jar:$CLASSPATH java Dumper root
public class Dump {

    public static void main (String[] args) {

        // Проверить, что программа запущена с аргументом
        if (args.length < 1) {
            System.out.println("USAGE: java Dumper <username>");
            System.exit(-1);
        }
        
        // Проверять ошибки в конце
        try {

            // Подключиться к базе
            Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/mysql?user=root");

            // Подготовить и выполнить запрос
            PreparedStatement stmt = conn.prepareStatement("SELECT * FROM user WHERE user=?");
            stmt.setString(1, args[0]);
            ResultSet rs = stmt.executeQuery();

            // Вывести данные
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= columns; ++i) {
                    System.out.print(rs.getString(i) + "\t");
                }
                System.out.println("");
            }

        } catch (Exception ex) {
            System.out.println("Got error: " + ex.getMessage());
        }
    }
}
